<?php
$csp_l10n_langs = array(
	'af' => array('af_AF'),
	'ar' => array('ar_AE','ar_BH','ar_DZ','ar_EG','ar_IQ','ar_JO','ar_KW','ar_LB','ar_LY','ar_MA','ar_OM','ar_QA','ar_SA','ar_SY','ar_TN','ar_YE'),
	'az' => array('az_AZ'),
	'be' => array('be_BY'),
	'bg' => array('bg_BG'),
	'bs' => array('bs_BA'),
	'by' => array('by_BY'),
	'ca' => array('ca_ES'),
	'cs' => array('cs_CZ'),
	'da' => array('da_DK'),
	'de' => array('de_AT','de_CH','de_DE','de_LU'),
	'el' => array('el_CY','el_GR', 'el_EL'),
	'en' => array('en_AU','en_CA','en_GB','en_IE','en_NZ','en_PH','en_US','en_ZA'),
	'es' => array('es_AR','es_BO','es_CL','es_CO','es_CR','es_DO','es_EC','es_ES','es_GT','es_HN','es_MX','es_NI','es_PA','es_PE','es_PR','es_PY','es_SV','es_UY','es_VE'),
	'et' => array('et_EE'),
	'eo' => array('eo_EO'),
	'eu' => array('eu_ES'),
	'fa' => array('fa_IR'),
	'fi' => array('fi_FI'),
	'fo' => array('fo_FO'),
	'fr' => array('fr_BE','fr_CA','fr_CH','fr_FR','fr_LU'),
	'fy' => array('fy_NL'),
	'ga' => array('ga_IE'),
	'gl' => array('gl_ES'),
	'he' => array('he_IL'),
	'hi' => array('hi_IN'),
	'hr' => array('hr_HR'),
	'hu' => array('hu_HU'),
	'hy' => array('hy_AM'),
	'id' => array('id_ID'),
	'in' => array('in_ID'),
	'is' => array('is_IS'),
	'it' => array('it_CH','it_IT'),
	'ja' => array('ja_JP'),
	'ka' => array('ka_GE'),
	'kk' => array('kk_KK'),
	'ko' => array('ko_KR'),
	'ky' => array('ky_KY'),
	'lb' => array('lb_LB'),
	'lt' => array('lt_LT'),
	'lv' => array('lv_LV'),
	'mk' => array('mk_MK'),
	'mn' => array('mn_MN'),
	'my' => array('my_MM'),
	'nb' => array('nb_NB', 'nb_NO'),
	'nl' => array('nl_BE','nl_NL'),
	'nn' => array('nn_NO'),
	'no' => array('no_NO'),
	'pl' => array('pl_PL'),
	'pt' => array('pt_BR','pt_PT'),
	'ro' => array('ro_RO'),
	'ru' => array('ru_RU'),
	'sk' => array('sk_SK'),
	'sl' => array('sl_SI'),
	'sq' => array('sq_AL'),
	'sr' => array('sr_BA','sr_CS', 'sr_RS'),
	'sv' => array('sv_SE'),
	'th' => array('th_TH'),
	'tl' => array('tl_PH'),
	'tr' => array('tr_TR'),
	'uk' => array('uk_UA'),
	'ug' => array('ug_CN'),
	'vi' => array('vi_VN'),
	'xh' => array('xh_XH'),
	'zh' => array('zh_CN','zh-MO','zh_HK','zh_SG','zh_TW'),
	'zu' => array('zu_ZU'),
);

$csp_l10n_login_label = array(
	'af' => "Taal",
	'ar' => "لغة",
	'az' => "Dil",
	'be' => "МО́ВА",
	'bg' => "Език",
	'bs' => "Язык",
	'by' => "Язык",
	'ca' => "Llenguatge",
	'cs' => "Jazyk",
	'da' => "Sprog",
	'de' => "Sprache",
	'el' => "Γλώσσα",
	'en' => "Language",
	'eo' => "Lingvo",
	'es' => "Idioma",
	'et' => "Keel",
	'eu' => "Hizkuntza",
	'fa' => "فارسی",
	'fi' => "Kieli",
	'fo' => "Mál",
	'fr' => "Langue",
	'fy' => "Taal",
	'ga' => "Teanga",
	'gl' => "Linguaxe",
	'he' => "שפה",
	'hi' => "हिन्दी",
	'hr' => "Jezik",
	'hu' => "Nyelv",
	'hy' => "լեզու",
	'id' => "Bahasa",
	'in' => "Bahasa",
	'is' => "Tungumál",
	'it' => "Lingua",
	'ja' => "言語",
	'ka' => "ენა",
	'kk' => "Language",
	'ko' => "언어",
	'ky' => "Тил",
	'lb' => "Sprooch",
	'lt' => "Kalba",
	'lv' => "Valoda",
	'mk' => "Јазик",
	'mn' => "ᠬᠡᠯᠡ",
	'my' => "Language",
	'nb' => "Språk",
	'nl' => "Taal",
	'nn' => "Språk",
	'no' => "Språk",
	'pl' => "Język",
	'pt' => "Língua",
	'ro' => "Language",
	'ru' => "Язык",
	'sk' => "Jazyk",
	'sl' => "Jazyk",
	'sq' => "Gjuha",
	'sr' => "Језик",
	'sv' => "Språk",
	'th' => "ภาษา",
	'tl' => "Wikang",
	'tr' => "Dil",
	'uk' => "Мова",
	'ug' => "Language",
	'vi' => "Ngôn ngữ",
	'xh' => "Ulwimi",
	'zh' => "语言",
	'zu' => "Language",
);

//based on http://translate.sourceforge.net/wiki/l10n/pluralforms
$csp_l10n_plurals = array(
	'af' => "nplurals=2; plural=n != 1;",
	'ar' => "nplurals=6; plural=n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5;",
	'az' => "nplurals=2; plural=n != 1;",
	'be' => "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);",
	'bg' => "nplurals=2; plural=n != 1;",
	'bs' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'by' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'ca' => "nplurals=2; plural=n != 1;",
	'cs' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'da' => "nplurals=2; plural=n != 1;",
	'de' => "nplurals=2; plural=n != 1;",
	'el' => "nplurals=2; plural=n != 1;",
	'en' => "nplurals=2; plural=n != 1;",
	'es' => "nplurals=2; plural=n != 1;",
	'et' => "nplurals=2; plural=n != 1;",
	'eo' => "nplurals=2; plural=n != 1;",
	'eu' => "nplurals=2; plural=n != 1;",
	'fa' => "nplurals=1; plural=0;",
	'fi' => "nplurals=2; plural=n != 1;",
	'fo' => "nplurals=2; plural=n != 1;",
	'fr' => "nplurals=2; plural=n>1;",
	'fy' => "nplurals=2; plural=n != 1;",
	'ga' => "nplurals=5; plural=n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4;",
	'gl' => "nplurals=2; plural=(n != 1);",
	'he' => "nplurals=2; plural=n != 1;",
	'hi' => "nplurals=2; plural=n != 1;",
	'hr' => "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);",
	'hu' => "nplurals=1; plural=0;",
	'hy' => "nplurals=2; plural=n != 1;",
	'id' => "nplurals=2; plural=n != 1;",
	'in' => "nplurals=2; plural=n != 1;",
	'is' => "nplurals=2; plural=(n%10!=1 || n%100==11);",
	'it' => "nplurals=2; plural=n != 1;",
	'ja' => "nplurals=1; plural=0;",
	'ka' => "nplurals=1; plural=0;",
	'kk' => "nplurals=1; plural=0;",
	'ko' => "nplurals=1; plural=0;",
	'ky' => "nplurals=2; plural=n != 1;",
	'lb' => "nplurals=2; plural=n != 1;",
	'lt' => "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && (n%100<10 || n%100>=20) ? 1 : 2;",
	'lv' => "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n != 0 ? 1 : 2;",
	'mk' => "nplurals=2; plural= n==1 || n%10==1 ? 0 : 1;",
	'mn' => "nplurals=2; plural=n != 1;",
	'my' => "nplurals=2; plural=n != 1;",
	'nb' => "nplurals=2; plural=n != 1;",
	'nl' => "nplurals=2; plural=n != 1;",
	'nn' => "nplurals=2; plural=n != 1;",
	'no' => "nplurals=2; plural=n != 1;",
	'pl' => "nplurals=3; plural=n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;",
	'pt' => "nplurals=2; plural=n != 1;",
	'ro' => "nplurals=3; plural=(n==1 ? 0 : (n==0 || (n%100 > 0 && n%100 < 20)) ? 1 : 2); ",
	'ru' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'sk' => "nplurals=3; plural=(n==1) ? 1 : (n>=2 && n<=4) ? 2 : 0;",
	'sl' => "nplurals=4; plural=n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3;",
	'sq' => "nplurals=2; plural=n != 1;", //may not be correct!
	'sr' => "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);",
	'sv' => "nplurals=2; plural=n != 1;",
	'th' => "nplurals=1; plural=0;",
	'tl' => "nplurals=2; plural=n != 1;",
	'tr' => "nplurals=2; plural=(n>1);",
	'uk' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'ug' => "nplurals=1; plural=0;",
	'vi' => "nplurals=1; plural=0;",
	'xh' => "nplurals=2; plural=n != 1;",
	'zh' => "nplurals=1; plural=0;",
	'zu' => "nplurals=2; plural=n != 1;",
);

$csp_l10n_sys_locales = array(
	'af_AF' => array (
		'country' => "South Africa",
		'country-www' => 'af',
		'lang' => 'Afrikaans',
		'lang-native' => 'Afrikaans',
		'lang-www' => 'af-AF',
		'dir' => 'ltr',
		'ms-loc' => 'afk',
		'ms-cp' => 'CP1252',
		'google-api' => 'af',
		'microsoft-api' => ''
	),
	'ar_AE' => array (
		'country' => "U.A.E.",
		'country-www' => 'ae',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الإمارات',
		'lang-www' => 'ar-AE',
		'dir' => 'rtl',
		'ms-loc' => 'aru',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_BH' => array (
		'country' => "Bahrain",
		'country-www' => 'bh',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/البحرين',
		'lang-www' => 'ar-BH',
		'dir' => 'rtl',
		'ms-loc' => 'arh',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_DZ' => array (
		'country' => "Algeria",
		'country-www' => 'dz',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الجزائر',
		'lang-www' => 'ar-DZ',
		'dir' => 'rtl',
		'ms-loc' => 'arg',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_EG' => array (
		'country' => "Egypt",
		'country-www' => 'eg',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/مصر',
		'lang-www' => 'ar-EG',
		'dir' => 'rtl',
		'ms-loc' => 'are',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_IQ' => array (
		'country' => "Iraq",
		'country-www' => 'iq',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/العراق',
		'lang-www' => 'ar-IQ',
		'dir' => 'rtl',
		'ms-loc' => 'ari',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_JO' => array (
		'country' => "Jordan",
		'country-www' => 'jo',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الأردن',
		'lang-www' => 'ar-JO',
		'dir' => 'rtl',
		'ms-loc' => 'arj',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_KW' => array (
		'country' => "Kuwait",
		'country-www' => 'kw',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الكويت',
		'lang-www' => 'ar-KW',
		'dir' => 'rtl',
		'ms-loc' => 'ark',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_LB' => array (
		'country' => "Lebanon",
		'country-www' => 'lb',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/لبنان',
		'lang-www' => 'ar-LB',
		'dir' => 'rtl',
		'ms-loc' => 'arb',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_LY' => array (
		'country' => "Libya",
		'country-www' => 'ly',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/ليبيا',
		'lang-www' => 'ar-LY',
		'dir' => 'rtl',
		'ms-loc' => 'arl',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_MA' => array (
		'country' => "Morocco",
		'country-www' => 'ma',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/المغرب',
		'lang-www' => 'ar-MA',
		'dir' => 'rtl',
		'ms-loc' => 'arm',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_OM' => array (
		'country' => "Oman",
		'country-www' => 'om',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/سلطنة عمان',
		'lang-www' => 'ar-OM',
		'dir' => 'rtl',
		'ms-loc' => 'aro',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_QA' => array (
		'country' => "Qatar",
		'country-www' => 'qa',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/قطر',
		'lang-www' => 'ar-QA',
		'dir' => 'rtl',
		'ms-loc' => 'arq',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_SA' => array (
		'country' => "Saudi Arabia",
		'country-www' => 'sa',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/السعودية',
		'lang-www' => 'ar-SA',
		'dir' => 'rtl',
		'ms-loc' => 'ara',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_SY' => array (
		'country' => "Syria",
		'country-www' => 'sy',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/سوريا',
		'lang-www' => 'ar-SY',
		'dir' => 'rtl',
		'ms-loc' => 'ars',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_TN' => array (
		'country' => "Tunisia",
		'country-www' => 'tn',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/تونس',
		'lang-www' => 'ar-TN',
		'dir' => 'rtl',
		'ms-loc' => 'art',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'ar_YE' => array (
		'country' => "Yemen",
		'country-www' => 'ye',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/اليمن',
		'lang-www' => 'ar-YE',
		'dir' => 'rtl',
		'ms-loc' => 'ary',
		'ms-cp' => 'CP1256',
		'google-api' => 'ar',
		'microsoft-api' => 'ar'
	),
	'az_AZ' => array (
		'country' => "Azerbaijan",
		'country-www' => 'az',
		'lang' => 'Azeri (Latin)',
		'lang-native' => 'Azərbaycan',
		'lang-www' => 'az-AZ',
		'dir' => 'ltr',
		'ms-loc' => 'aze',
		'ms-cp' => 'CP1254',
		'google-api' => 'az',
		'microsoft-api' => ''
	),
	'be_BY' => array (
		'country' => "Belarus",
		'country-www' => 'by',
		'lang' => 'Belarusian',
		'lang-native' => 'Беларускі',
		'lang-www' => 'be-BY',
		'dir' => 'ltr',
		'ms-loc' => 'bel',
		'ms-cp' => 'CP1251',
		'google-api' => 'be',
		'microsoft-api' => ''
	),
	'bg_BG' => array (
		'country' => "Bulgaria",
		'country-www' => 'bg',
		'lang' => 'Bulgarian',
		'lang-native' => 'Български',
		'lang-www' => 'bg-BG',
		'dir' => 'ltr',
		'ms-loc' => 'bgr',
		'ms-cp' => 'CP1251',
		'google-api' => 'bg',
		'microsoft-api' => ''
	),
	'bs_BA' => array (
		'country' => "Bosnia and Herzegowina",
		'country-www' => 'ba',
		'lang' => 'Bosnian',
		'lang-native' => 'босански',
		'lang-www' => 'ba-BA',
		'dir' => 'ltr',
		'ms-loc' => 'bos',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'by_BY' => array (
		'country' => "Belarus",
		'country-www' => 'by',
		'lang' => 'Belarusian',
		'lang-native' => 'Беларускі',
		'lang-www' => 'by-BY',
		'dir' => 'ltr',
		'ms-loc' => 'bel',
		'ms-cp' => 'CP1251',
		'google-api' => 'be',
		'microsoft-api' => ''
	),
	'ca_ES' => array (
		'country' => "Spain",
		'country-www' => 'es',
		'lang' => 'Catalan',
		'lang-native' => 'Сatalà/Espanya',
		'lang-www' => 'ca-ES',
		'dir' => 'ltr',
		'ms-loc' => 'cat',
		'ms-cp' => 'CP1252',
		'google-api' => 'ca',
		'microsoft-api' => ''
	),
	'cs_CZ' => array (
		'country' => "Czech Republic",
		'country-www' => 'cz',
		'lang' => 'Czech',
		'lang-native' => 'Čeština',
		'lang-www' => 'cs-CZ',
		'dir' => 'ltr',
		'ms-loc' => 'csy',
		'ms-cp' => 'CP1250',
		'google-api' => 'cs',
		'microsoft-api' => 'cs'
	),
	'da_DK' => array (
		'country' => "Denmark",
		'country-www' => 'dk',
		'lang' => 'Danish',
		'lang-native' => 'Dansk',
		'lang-www' => 'da-DK',
		'dir' => 'ltr',
		'ms-loc' => 'dan',
		'ms-cp' => 'CP1252',
		'google-api' => 'da',
		'microsoft-api' => 'da'
	),
	'de_AT' => array (
		'country' => "Austria",
		'country-www' => 'at',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Österreich',
		'lang-www' => 'de-AT',
		'dir' => 'ltr',
		'ms-loc' => 'dea',
		'ms-cp' => 'CP1252',
		'google-api' => 'de',
		'microsoft-api' => 'de'
	),
	'de_CH' => array (
		'country' => "Switzerland",
		'country-www' => 'ch',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Schweiz',
		'lang-www' => 'de-CH',
		'dir' => 'ltr',
		'ms-loc' => 'des',
		'ms-cp' => 'CP1252',
		'google-api' => 'de',
		'microsoft-api' => 'de'
	),
	'de_DE' => array (
		'country' => "Germany",
		'country-www' => 'de',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Deutschland',
		'lang-www' => 'de-DE',
		'dir' => 'ltr',
		'ms-loc' => 'deu',
		'ms-cp' => 'CP1252',
		'google-api' => 'de',
		'microsoft-api' => 'de'
	),
	'de_LU' => array (
		'country' => "Luxembourg",
		'country-www' => 'lu',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Luxemburg',
		'lang-www' => 'de-LU',
		'dir' => 'ltr',
		'ms-loc' => 'del',
		'ms-cp' => 'CP1252',
		'google-api' => 'de',
		'microsoft-api' => 'de'
	),
	'el_CY' => array (
		'country' => "Greece",
		'country-www' => 'cy',
		'lang' => 'Greek',
		'lang-native' => 'Ελληνικά/Κύπρος',
		'lang-www' => 'el-CY',
		'dir' => 'ltr',
		'ms-loc' => 'ell',
		'ms-cp' => 'CP1253',
		'google-api' => 'el',
		'microsoft-api' => 'el'
	),
	'el_GR' => array (
		'country' => "Greece",
		'country-www' => 'gr',
		'lang' => 'Greek',
		'lang-native' => 'Ελληνικά/Ελλάδα',
		'lang-www' => 'el-GR',
		'dir' => 'ltr',
		'ms-loc' => 'ell',
		'ms-cp' => 'CP1253',
		'google-api' => 'el',
		'microsoft-api' => 'el'
	),
	'el_EL' => array (
		'country' => "Greece",
		'country-www' => 'el',
		'lang' => 'Greek',
		'lang-native' => 'Ελληνικά/Ελλάδα',
		'lang-www' => 'el-EL',
		'dir' => 'ltr',
		'ms-loc' => 'ell',
		'ms-cp' => 'CP1253',
		'google-api' => 'el',
		'microsoft-api' => 'el'
	),
	'en_AU' => array (
		'country' => "Australia",
		'country-www' => 'au',
		'lang' => 'English',
		'lang-native' => 'English/Australia',
		'lang-www' => 'en-AU',
		'dir' => 'ltr',
		'ms-loc' => 'ena',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'en_CA' => array (
		'country' => "Canada",
		'country-www' => 'ca',
		'lang' => 'English',
		'lang-native' => 'English/Canada',
		'lang-www' => 'en-CA',
		'dir' => 'ltr',
		'ms-loc' => 'enc',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'en_GB' => array (
		'country' => "United Kingdom",
		'country-www' => 'gb',
		'lang' => 'English',
		'lang-native' => 'English/United Kingdom',
		'lang-www' => 'en-GB',
		'dir' => 'ltr',
		'ms-loc' => 'eng',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'en_IE' => array (
		'country' => "Ireland",
		'country-www' => 'ie',
		'lang' => 'English',
		'lang-native' => 'English/Ireland',
		'lang-www' => 'en-IE',
		'dir' => 'ltr',
		'ms-loc' => 'eni',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'en_NZ' => array (
		'country' => "New Zealand",
		'country-www' => 'nz',
		'lang' => 'English',
		'lang-native' => 'English/New Zealand',
		'lang-www' => 'en-NZ',
		'dir' => 'ltr',
		'ms-loc' => 'enz',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'en_PH' => array (
		'country' => "Republic of the Philippines",
		'country-www' => 'ph',
		'lang' => 'English',
		'lang-native' => 'English/Philippines',
		'lang-www' => 'en-PH',
		'dir' => 'ltr',
		'ms-loc' => 'enp',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'en_US' => array (
		'country' => "United States",
		'country-www' => 'us',
		'lang' => 'English',
		'lang-native' => 'English/United States',
		'lang-www' => 'en-US',
		'dir' => 'ltr',
		'ms-loc' => 'enu',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'en_ZA' => array (
		'country' => "South Africa",
		'country-www' => 'za',
		'lang' => 'English',
		'lang-native' => 'English/South Africa',
		'lang-www' => 'en-ZA',
		'dir' => 'ltr',
		'ms-loc' => 'ens',
		'ms-cp' => 'CP1252',
		'google-api' => 'en',
		'microsoft-api' => 'en'
	),
	'eo_EO' => array (
		'country' => "-n.a.-",
		'country-www' => 'eo',
		'lang' => 'Esperanto',
		'lang-native' => 'Esperanto',
		'lang-www' => 'eo-EO',
		'dir' => 'ltr',
		'ms-loc' => 'enu',
		'ms-cp' => 'CP1252',
		'google-api' => 'eo',
		'microsoft-api' => ''
	),	
	'es_AR' => array (
		'country' => "Argentina",
		'country-www' => 'ar',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Argentina',
		'lang-www' => 'es-AR',
		'dir' => 'ltr',
		'ms-loc' => 'ess',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_BO' => array (
		'country' => "Bolivia",
		'country-www' => 'bo',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Bolivia',
		'lang-www' => 'es-BO',
		'dir' => 'ltr',
		'ms-loc' => 'esb',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_CL' => array (
		'country' => "Chile",
		'country-www' => 'cl',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Chile',
		'lang-www' => 'es-CL',
		'dir' => 'ltr',
		'ms-loc' => 'esl',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_CO' => array (
		'country' => "Colombia",
		'country-www' => 'co',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Colombia',
		'lang-www' => 'es-CO',
		'dir' => 'ltr',
		'ms-loc' => 'eso',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_CR' => array (
		'country' => "Costa Rica",
		'country-www' => 'cr',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Costa Rica',
		'lang-www' => 'es-CR',
		'dir' => 'ltr',
		'ms-loc' => 'esc',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_DO' => array (
		'country' => "Dominican Republic",
		'country-www' => 'do',
		'lang' => 'Spanish',
		'lang-native' => 'Español/República Dominicana',
		'lang-www' => 'es-DO',
		'dir' => 'ltr',
		'ms-loc' => 'esd',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_EC' => array (
		'country' => "Ecuador",
		'country-www' => 'ec',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Ecuador',
		'lang-www' => 'es-EC',
		'dir' => 'ltr',
		'ms-loc' => 'esf',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_ES' => array (
		'country' => "Spain",
		'country-www' => 'es',
		'lang' => 'Spanish',
		'lang-native' => 'Español/España',
		'lang-www' => 'es-ES',
		'dir' => 'ltr',
		'ms-loc' => 'esp',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_GT' => array (
		'country' => "Guatemala",
		'country-www' => 'gt',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Guatemala',
		'lang-www' => 'es-GT',
		'dir' => 'ltr',
		'ms-loc' => 'esg',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_HN' => array (
		'country' => "Honduras",
		'country-www' => 'hn',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Honduras',
		'lang-www' => 'es-HN',
		'dir' => 'ltr',
		'ms-loc' => 'esh',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_MX' => array (
		'country' => "Mexico",
		'country-www' => 'mx',
		'lang' => 'Spanish',
		'lang-native' => 'Español/México',
		'lang-www' => 'es-MX',
		'dir' => 'ltr',
		'ms-loc' => 'esm',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_NI' => array (
		'country' => "Nicaragua",
		'country-www' => 'ni',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Nicaragua',
		'lang-www' => 'es-NI',
		'dir' => 'ltr',
		'ms-loc' => 'esi',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_PA' => array (
		'country' => "Panama",
		'country-www' => 'pa',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Panamá',
		'lang-www' => 'es-PA',
		'dir' => 'ltr',
		'ms-loc' => 'esa',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_PE' => array (
		'country' => "Peru",
		'country-www' => 'pe',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Perú',
		'lang-www' => 'es-PE',
		'dir' => 'ltr',
		'ms-loc' => 'esr',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_PR' => array (
		'country' => "Puerto Rico",
		'country-www' => 'pr',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Puerto Rico',
		'lang-www' => 'es-PR',
		'dir' => 'ltr',
		'ms-loc' => 'esu',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_PY' => array (
		'country' => "Paraguay",
		'country-www' => 'py',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Paraguay',
		'lang-www' => 'es-PY',
		'dir' => 'ltr',
		'ms-loc' => 'esz',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_SV' => array (
		'country' => "El Salvador",
		'country-www' => 'sv',
		'lang' => 'Spanish',
		'lang-native' => 'Español/El Salvador',
		'lang-www' => 'es-SV',
		'dir' => 'ltr',
		'ms-loc' => 'ese',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_UY' => array (
		'country' => "Uruguay",
		'country-www' => 'uy',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Uruguay',
		'lang-www' => 'es-UY',
		'dir' => 'ltr',
		'ms-loc' => 'esy',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'es_VE' => array (
		'country' => "Venezuela",
		'country-www' => 've',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Venezuela',
		'lang-www' => 'es-VE',
		'dir' => 'ltr',
		'ms-loc' => 'esv',
		'ms-cp' => 'CP1252',
		'google-api' => 'es',
		'microsoft-api' => 'es'
	),
	'et_EE' => array (
		'country' => "Estonia",
		'country-www' => 'ee',
		'lang' => 'Estonian',
		'lang-native' => 'Eesti/Eesti',
		'lang-www' => 'et-EE',
		'dir' => 'ltr',
		'ms-loc' => 'eti',
		'ms-cp' => 'CP1257',
		'google-api' => 'et',
		'microsoft-api' => 'et'
	),
	'eu_ES' => array (
		'country' => "Basque",
		'country-www' => 'eu',
		'lang' => 'Basque',
		'lang-native' => 'Euskara/Basque',
		'lang-www' => 'eu-ES',
		'dir' => 'ltr',
		'ms-loc' => 'eh',
		'ms-cp' => 'CP1257',
		'google-api' => 'eu',
		'microsoft-api' => ''
	),
	'fa_IR' => array (
		'country' => "Iran",
		'country-www' => 'ir',
		'lang' => 'Farsi',
		'lang-native' => "فارسی",
		'lang-www' => 'fa-IR',
		'dir' => 'rtl',
		'ms-loc' => 'far',
		'ms-cp' => 'CP1252',
		'google-api' => 'fa',
		'microsoft-api' => ''
	),
	'fi_FI' => array (
		'country' => "Finland",
		'country-www' => 'fi',
		'lang' => 'Finnish',
		'lang-native' => 'Suomi',
		'lang-www' => 'fi-FI',
		'dir' => 'ltr',
		'ms-loc' => 'fin',
		'ms-cp' => 'CP1252',
		'google-api' => 'fi',
		'microsoft-api' => 'fi'
	),
	'fo_FO' => array (
		'country' => "Faroe Islands",
		'country-www' => 'fo',
		'lang' => 'Faroese',
		'lang-native' => 'Føroyskt',
		'lang-www' => 'fo-FO',
		'dir' => 'ltr',
		'ms-loc' => 'fos',
		'ms-cp' => 'CP1252',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'fr_BE' => array (
		'country' => "Belgium",
		'country-www' => 'be',
		'lang' => 'French',
		'lang-native' => 'Français/Belgique',
		'lang-www' => 'fr-BE',
		'dir' => 'ltr',
		'ms-loc' => 'frb',
		'ms-cp' => 'CP1252',
		'google-api' => 'fr',
		'microsoft-api' => 'fr'
	),
	'fr_CA' => array (
		'country' => "Canada",
		'country-www' => 'ca',
		'lang' => 'French',
		'lang-native' => 'Français/Canada',
		'lang-www' => 'fr-CA',
		'dir' => 'ltr',
		'ms-loc' => 'frc',
		'ms-cp' => 'CP1252',
		'google-api' => 'fr',
		'microsoft-api' => 'fr'
	),
	'fr_CH' => array (
		'country' => "Switzerland",
		'country-www' => 'ch',
		'lang' => 'French',
		'lang-native' => 'Français/Suisse',
		'lang-www' => 'fr-CH',
		'dir' => 'ltr',
		'ms-loc' => 'frs',
		'ms-cp' => 'CP1252',
		'google-api' => 'fr',
		'microsoft-api' => 'fr'
	),
	'fr_FR' => array (
		'country' => "France",
		'country-www' => 'fr',
		'lang' => 'French',
		'lang-native' => 'Français/France',
		'lang-www' => 'fr-FR',
		'dir' => 'ltr',
		'ms-loc' => 'fra',
		'ms-cp' => 'CP1252',
		'google-api' => 'fr',
		'microsoft-api' => 'fr'
	),
	'fr_LU' => array (
		'country' => "Luxembourg",
		'country-www' => 'lu',
		'lang' => 'French',
		'lang-native' => 'Français/Luxembourg',
		'lang-www' => 'fr-LU',
		'dir' => 'ltr',
		'ms-loc' => 'frl',
		'ms-cp' => 'CP1252',
		'google-api' => 'fr',
		'microsoft-api' => 'fr'
	),
	'fy_NL' => array (
		'country' => "Netherlands",
		'country-www' => 'nl',
		'lang' => 'Frisian',
		'lang-native' => 'Frysk',
		'lang-www' => 'fy-NL',
		'dir' => 'ltr',
		'ms-loc' => 'fyn',
		'ms-cp' => 'CP1252',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'ga_IE' => array (
		'country' => "Ireland",
		'country-www' => 'ie',
		'lang' => 'Irish',
		'lang-native' => 'Gaeilge/Éire',
		'lang-www' => 'ga-IE',
		'dir' => 'ltr',
		'ms-loc' => 'ire',
		'ms-cp' => 'CP1252',
		'google-api' => 'ga',
		'microsoft-api' => ''
	),
	'gl_ES' => array(
		'country' => "Espana",
		'country-www' => 'gl',
		'lang' => 'Galego',
		'lang-native' => 'Galego',
		'lang-www' => 'gl-ES',
		'dir' => 'ltr',
		'ms-loc' => 'gel',
		'ms-cp' => 'CP1255',
		'google-api' => 'gl',
		'microsoft-api' => ''
	),
	'he_IL' => array (
		'country' => "Israel",
		'country-www' => 'il',
		'lang' => 'Hebrew',
		'lang-native' => 'עברית',
		'lang-www' => 'he-IL',
		'dir' => 'rtl',
		'ms-loc' => 'heb',
		'ms-cp' => 'CP1255',
		'google-api' => 'he',
		'microsoft-api' => 'he'
	),
	'hi_IN' => array (
		'country' => "India",
		'country-www' => 'in',
		'lang' => 'Hindi',
		'lang-native' => 'हिन्दी',
		'lang-www' => 'hi-IN',
		'dir' => 'ltr',
		'ms-loc' => 'hin',
		'ms-cp' => 'CP1255',
		'google-api' => 'hi',
		'microsoft-api' => ''
	),
	'hr_HR' => array (
		'country' => "Croatia",
		'country-www' => 'hr',
		'lang' => 'Croatian',
		'lang-native' => 'Hrvatski',
		'lang-www' => 'hr-HR',
		'dir' => 'ltr',
		'ms-loc' => 'hrv',
		'ms-cp' => 'CP1250',
		'google-api' => 'hr',
		'microsoft-api' => ''
	),
	'hu_HU' => array (
		'country' => "Hungary",
		'country-www' => 'hu',
		'lang' => 'Hungarian',
		'lang-native' => 'Magyar',
		'lang-www' => 'hu-HU',
		'dir' => 'ltr',
		'ms-loc' => 'hun',
		'ms-cp' => 'CP1250',
		'google-api' => 'hu',
		'microsoft-api' => 'hu'
	),
	'hy_AM' => array (
		'country' => "Armenia",
		'country-www' => 'hy',
		'lang' => 'Armenian',
		'lang-native' => 'հայերեն/Հայաստան',
		'lang-www' => 'hy-AM',
		'dir' => 'ltr',
		'ms-loc' => 'hy',
		'ms-cp' => 'CP1256',
		'google-api' => 'hy',
		'microsoft-api' => ''
	),
	'id_ID' => array (
		'country' => "Indonesia",
		'country-www' => 'id',
		'lang' => 'Indonesian',
		'lang-native' => 'Bahasa Indonesia',
		'lang-www' => 'id-ID',
		'dir' => 'ltr',
		'ms-loc' => 'ind',
		'ms-cp' => 'CP1252',
		'google-api' => 'id',
		'microsoft-api' => 'id'
	),
	'in_ID' => array (
		'country' => "Indonesia",
		'country-www' => 'id',
		'lang' => 'Indonesian',
		'lang-native' => 'Bahasa Indonesia/Indonesia',
		'lang-www' => 'in-ID',
		'dir' => 'ltr',
		'ms-loc' => 'ind',
		'ms-cp' => 'CP1252',
		'google-api' => 'id',
		'microsoft-api' => 'id'
	),
	'is_IS' => array (
		'country' => "Iceland",
		'country-www' => 'is',
		'lang' => 'Icelandic',
		'lang-native' => 'Íslenska/Ísland',
		'lang-www' => 'is-IS',
		'dir' => 'ltr',
		'ms-loc' => 'isl',
		'ms-cp' => 'CP1252',
		'google-api' => 'is',
		'microsoft-api' => ''
	),
	'it_CH' => array (
		'country' => "Switzerland",
		'country-www' => 'ch',
		'lang' => 'Italian',
		'lang-native' => 'Italiano/Svizzera',
		'lang-www' => 'it-CH',
		'dir' => 'ltr',
		'ms-loc' => 'its',
		'ms-cp' => 'CP1252',
		'google-api' => 'it',
		'microsoft-api' => 'it'
	),
	'it_IT' => array (
		'country' => "Italy",
		'country-www' => 'it',
		'lang' => 'Italian',
		'lang-native' => 'Italiano/Italia',
		'lang-www' => 'it-IT',
		'dir' => 'ltr',
		'ms-loc' => 'ita',
		'ms-cp' => 'CP1252',
		'google-api' => 'it',
		'microsoft-api' => 'it'
	),
	'ja_JP' => array (
		'country' => "Japan",
		'country-www' => 'jp',
		'lang' => 'Japanese',
		'lang-native' => '日本語',
		'lang-www' => 'ja-JP',
		'dir' => 'ltr',
		'ms-loc' => 'jpn',
		'ms-cp' => 'CP932',
		'google-api' => 'ja',
		'microsoft-api' => 'ja'
	),
	'ka_GE' => array(
		'country' => "Kazakhstan",
		'country-www' => 'ka',
		'lang' => 'Georgian',
		'lang-native' => "ქართული",
		'lang-www' => 'ka-GE',
		'dir' => 'ltr',
		'ms-loc' => 'geo',
		'ms-cp' => '',
		'google-api' => 'ka',
		'microsoft-api' => ''
	),
	'kk_KK' => array (
		'country' => "Kazakhstan",
		'country-www' => 'kk',
		'lang' => 'Kazakh',
		'lang-native' => 'Қазақша',
		'lang-www' => 'kk-KK',
		'dir' => 'ltr',
		'ms-loc' => 'kkz',
		'ms-cp' => 'CP1251',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'ko_KR' => array (
		'country' => "Korea",
		'country-www' => 'kr',
		'lang' => 'Korean',
		'lang-native' => '한국어',
		'lang-www' => 'ko-KR',
		'dir' => 'ltr',
		'ms-loc' => 'kor',
		'ms-cp' => 'CP949',
		'google-api' => 'ko',
		'microsoft-api' => 'ko'
	),
	'ky_KY' => array (
		'country' => "Kyrgyzstan",
		'country-www' => 'ky',
		'lang' => 'Kyrgyz',
		'lang-native' => 'Кыргызча',
		'lang-www' => 'ky-KY',
		'dir' => 'ltr',
		'ms-loc' => 'kyr',
		'ms-cp' => 'CP1251',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'lb_LB' => array (
		'country' => "Luxembourg",
		'country-www' => 'lb',
		'lang' => 'Luxembourgish',
		'lang-native' => 'Lëtzebuergesch',
		'lang-www' => 'lb-LB',
		'dir' => 'ltr',
		'ms-loc' => 'lbx',
		'ms-cp' => 'CP1252',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'lt_LT' => array (
		'country' => "Lithuania",
		'country-www' => 'lt',
		'lang' => 'Lithuanian',
		'lang-native' => 'Lietuvių/Lietuva',
		'lang-www' => 'lt-LT',
		'dir' => 'ltr',
		'ms-loc' => 'lth',
		'ms-cp' => 'CP1257',
		'google-api' => 'lt',
		'microsoft-api' => 'lt'
	),
	'lv_LV' => array (
		'country' => "Latvia",
		'country-www' => 'lv',
		'lang' => 'Latvian',
		'lang-native' => 'Latviešu/Latvija',
		'lang-www' => 'lv-LV',
		'dir' => 'ltr',
		'ms-loc' => 'lvi',
		'ms-cp' => 'CP1257',
		'google-api' => 'lv',
		'microsoft-api' => 'lv'
	),
	'mk_MK' => array (
		'country' => "Former Yugoslav Republic of Macedonia",
		'country-www' => 'mk',
		'lang' => 'FYRO Macedonian',
		'lang-native' => 'Македонски/Македонија',
		'lang-www' => 'mk-MK',
		'dir' => 'ltr',
		'ms-loc' => 'mki',
		'ms-cp' => 'CP1251',
		'google-api' => 'mk',
		'microsoft-api' => ''
	),
	'mn_MN' => array (
		'country' => "Mongolia",
		'country-www' => 'mn',
		'lang' => 'Mongolian',
		'lang-native' => 'ᠮᠣᠨᠭᠭᠣᠯ',
		'lang-www' => 'mn-MN',
		'dir' => 'ltr',
		'ms-loc' => 'mon',
		'ms-cp' => 'CP1251',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'my_MM' => array (
		'country' => "Myanmar",
		'country-www' => 'mm',
		'lang' => 'myanma bhasa',
		'lang-native' => 'myanma bhasa',
		'lang-www' => 'my-MM',
		'dir' => 'ltr',
		'ms-loc' => 'bur',
		'ms-cp' => 'CP1251',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'nb_NB' => array (
		'country' => "Norway",
		'country-www' => 'no',
		'lang' => 'Norwegian (Bokmål)',
		'lang-native' => '‪Norsk Bokmål‬',
		'lang-www' => 'nb-NB',
		'dir' => 'ltr',
		'ms-loc' => 'nor',
		'ms-cp' => 'CP1252',
		'google-api' => 'no',
		'microsoft-api' => 'no'
	),
	'nb_NO' => array (
		'country' => "Norway",
		'country-www' => 'no',
		'lang' => 'Norwegian (Bokmål)',
		'lang-native' => '‪Norsk Bokmål‬',
		'lang-www' => 'nb-NO',
		'dir' => 'ltr',
		'ms-loc' => 'nor',
		'ms-cp' => 'CP1252',
		'google-api' => 'no',
		'microsoft-api' => 'no'
	),
	'nl_BE' => array (
		'country' => "Belgium",
		'country-www' => 'be',
		'lang' => 'Dutch',
		'lang-native' => 'Nederlands / België',
		'lang-www' => 'nl-BE',
		'dir' => 'ltr',
		'ms-loc' => 'nlb',
		'ms-cp' => 'CP1252',
		'google-api' => 'nl',
		'microsoft-api' => 'nl'
	),
	'nl_NL' => array (
		'country' => "Netherlands",
		'country-www' => 'nl',
		'lang' => 'Dutch',
		'lang-native' => 'Nederlands / Nederland',
		'lang-www' => 'nl-NL',
		'dir' => 'ltr',
		'ms-loc' => 'nld',
		'ms-cp' => 'CP1252',
		'google-api' => 'nl',
		'microsoft-api' => 'nl'
	),
	'nn_NO' => array (
		'country' => "Norway",
		'country-www' => 'nn',
		'lang' => 'Norwegian-Nynorsk',
		'lang-native' => 'Norsk / Nynorsk',
		'lang-www' => 'nn-NN',
		'dir' => 'ltr',
		'ms-loc' => 'non',
		'ms-cp' => 'CP1252',
		'google-api' => 'no',
		'microsoft-api' => 'no'
	),
	'no_NO' => array (
		'country' => "Norway",
		'country-www' => 'no',
		'lang' => 'Norwegian-Nynorsk',
		'lang-native' => 'Norsk / Norge',
		'lang-www' => 'no-NO',
		'dir' => 'ltr',
		'ms-loc' => 'non',
		'ms-cp' => 'CP1252',
		'google-api' => 'no',
		'microsoft-api' => 'no'
	),
	'pl_PL' => array (
		'country' => "Poland",
		'country-www' => 'pl',
		'lang' => 'Polish',
		'lang-native' => 'Polski/Polska',
		'lang-www' => 'pl-PL',
		'dir' => 'ltr',
		'ms-loc' => 'plk',
		'ms-cp' => 'CP1250',
		'google-api' => 'pl',
		'microsoft-api' => 'pl'
	),
	'pt_BR' => array (
		'country' => "Brazil",
		'country-www' => 'br',
		'lang' => 'Portuguese',
		'lang-native' => 'Português/Brasil',
		'lang-www' => 'pt-BR',
		'dir' => 'ltr',
		'ms-loc' => 'ptb',
		'ms-cp' => 'CP1252',
		'google-api' => 'pt',
		'microsoft-api' => 'pt'
	),
	'pt_PT' => array (
		'country' => "Portugal",
		'country-www' => 'pt',
		'lang' => 'Portuguese',
		'lang-native' => 'Português/Portugal',
		'lang-www' => 'pt-PT',
		'dir' => 'ltr',
		'ms-loc' => 'ptg',
		'ms-cp' => 'CP1252',
		'google-api' => 'pt',
		'microsoft-api' => 'pt'
	),
	'ro_RO' => array (
		'country' => "Romania",
		'country-www' => 'ro',
		'lang' => 'Romanian',
		'lang-native' => 'Română/România',
		'lang-www' => 'ro-RO',
		'dir' => 'ltr',
		'ms-loc' => 'rom',
		'ms-cp' => 'CP1250',
		'google-api' => 'ro',
		'microsoft-api' => 'ro'
	),
	'ru_RU' => array (
		'country' => "Russia",
		'country-www' => 'ru',
		'lang' => 'Russian',
		'lang-native' => 'Русский/Россия',
		'lang-www' => 'ru-RU',
		'dir' => 'ltr',
		'ms-loc' => 'rus',
		'ms-cp' => 'CP1251',
		'google-api' => 'ru',
		'microsoft-api' => 'ru'
	),
	'sk_SK' => array (
		'country' => "Slovakia",
		'country-www' => 'sk',
		'lang' => 'Slovak',
		'lang-native' => 'Slovenčina/Slovenská republika',
		'lang-www' => 'sk-SK',
		'dir' => 'ltr',
		'ms-loc' => 'sky',
		'ms-cp' => 'CP1250',
		'google-api' => 'sk',
		'microsoft-api' => 'sk'
	),
	'sl_SI' => array (
		'country' => "Slovenia",
		'country-www' => 'si',
		'lang' => 'Slovenian',
		'lang-native' => 'Slovenščina/Slovenija',
		'lang-www' => 'sl-SI',
		'dir' => 'ltr',
		'ms-loc' => 'slv',
		'ms-cp' => 'CP1250',
		'google-api' => 'sl',
		'microsoft-api' => 'sl'
	),
	'sq_AL' => array (
	   'country' => "Albania",
	   'country-www' => 'al',
	   'lang' => 'Albanian',
	   'lang-native' => 'Shqip',
	   'lang-www' => 'sq-AL',
	   'dir' => 'ltr',
	   'ms-loc' => 'sqi',
	   'ms-cp' => 'CP1250',
		'google-api' => 'sq',
		'microsoft-api' => ''
    ),
	'sr_BA' => array (
		'country' => "Bosnia and Herzegovina",
		'country-www' => 'ba',
		'lang' => 'Serbian (Cyrillic)',
		'lang-native' => 'Српски/Босна и Херцеговина',
		'lang-www' => 'sr-BA',
		'dir' => 'ltr',
		'ms-loc' => 'srn',
		'ms-cp' => 'CP1251',
		'google-api' => 'sr',
		'microsoft-api' => ''
	),
	'sr_CS' => array (
		'country' => "Serbia and Montenegro",
		'country-www' => 'cs',
		'lang' => 'Serbian (Cyrillic)',
		'lang-native' => 'Српски/Србија и Црна Гора',
		'lang-www' => 'sr-CS',
		'dir' => 'ltr',
		'ms-loc' => 'srb',
		'ms-cp' => 'CP1251',
		'google-api' => 'sr',
		'microsoft-api' => ''
	),
	'sr_RS' => array (
		'country' => "Serbia",
		'country-www' => 'rs',
		'lang' => 'Serbian',
		'lang-native' => 'Srpski/Srbija',
		'lang-www' => 'sr-RS',
		'dir' => 'ltr',
		'ms-loc' => 'srb',
		'ms-cp' => 'CP1251',
		'google-api' => 'sr',
		'microsoft-api' => ''
	),
	'sv_SE' => array (
		'country' => "Sweden",
		'country-www' => 'se',
		'lang' => 'Swedish',
		'lang-native' => 'Svenska/Sverige',
		'lang-www' => 'sv-SE',
		'dir' => 'ltr',
		'ms-loc' => 'sve',
		'ms-cp' => 'CP1252',
		'google-api' => 'sv',
		'microsoft-api' => 'sv'
	),
	'th_TH' => array (
		'country' => "Thailand",
		'country-www' => 'th',
		'lang' => 'Thai',
		'lang-native' => 'ไทย/ประเทศไทย',
		'lang-www' => 'th-TH',
		'dir' => 'ltr',
		'ms-loc' => 'tha',
		'ms-cp' => 'CP874',
		'google-api' => 'th',
		'microsoft-api' => 'th'
	),
	'tl_PH' => array (
		'country' => "Philippines",
		'country-www' => 'ph',
		'lang' => 'Tagalog',
		'lang-native' => 'Tagalog/Philippines',
		'lang-www' => 'tl-PH',
		'dir' => 'ltr',
		'ms-loc' => '',
		'ms-cp' => '',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'tr_TR' => array (
		'country' => "Turkey",
		'country-www' => 'tr',
		'lang' => 'Turkish',
		'lang-native' => 'Türkçe',
		'lang-www' => 'tr-TR',
		'dir' => 'ltr',
		'ms-loc' => 'trk',
		'ms-cp' => 'CP1254',
		'google-api' => 'tr',
		'microsoft-api' => 'tr'
	),
	'ug_CN' => array (
		'country' => "People's Republic of China",
		'country-www' => 'cn',
		'lang' => 'Uyghur',
		'lang-native' => 'ئۇيغۇر‎',
		'lang-www' => 'ug-CN',
		'dir' => 'rtl',
		'ms-loc' => 'ug',
		'ms-cp' => 'CP1251',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'uk_UA' => array (
		'country' => "Ukraine",
		'country-www' => 'ua',
		'lang' => 'Ukrainian',
		'lang-native' => 'Українська',
		'lang-www' => 'uk-UA',
		'dir' => 'ltr',
		'ms-loc' => 'ukr',
		'ms-cp' => 'CP1251',
		'google-api' => 'uk',
		'microsoft-api' => 'uk'
	),
	'vi_VN' => array (
		'country' => "Viet Nam",
		'country-www' => 'vn',
		'lang' => 'Vietnamese',
		'lang-native' => 'Tiếng Việt',
		'lang-www' => 'vi-VN',
		'dir' => 'ltr',
		'ms-loc' => 'vit',
		'ms-cp' => 'CP1258',
		'google-api' => 'vi',
		'microsoft-api' => 'vi'
	),
	'xh_XH' => array (
		'country' => "South Africa",
		'country-www' => 'xh',
		'lang' => 'Xhosa',
		'lang-native' => 'isiXhosa',
		'lang-www' => 'xh-XH',
		'dir' => 'ltr',
		'ms-loc' => 'xho',
		'ms-cp' => 'CP1252',
		'google-api' => '',
		'microsoft-api' => ''
	),
	'zh_CN' => array (
		'country' => "People's Republic of China",
		'country-www' => 'cn',
		'lang' => 'Chinese',
		'lang-native' => '中文(中华人民共和国)',
		'lang-www' => 'zh-CN',
		'dir' => 'ltr',
		'ms-loc' => 'chs',
		'ms-cp' => 'CP936',
		'google-api' => 'zh-CN',
		'microsoft-api' => 'zh-CHS'
	),
	'zh-MO' => array (
		'country' => "Macau S.A.R.",
		'country-www' => 'mo',
		'lang' => 'Chinese',
		'lang-native' => '中文(澳門特别行政區)',
		'lang-www' => 'zh-MO',
		'dir' => 'ltr',
		'ms-loc' => 'zhm',
		'ms-cp' => 'CP950',
		'google-api' => 'zh',
		'microsoft-api' => 'zh'
	),
	'zh_HK' => array (
		'country' => "Hong Kong S.A.R.",
		'country-www' => 'hk',
		'lang' => 'Chinese',
		'lang-native' => '中文(香港特别行政區)',
		'lang-www' => 'zh-HK',
		'dir' => 'ltr',
		'ms-loc' => 'zhh',
		'ms-cp' => 'CP950',
		'google-api' => 'zh',
		'microsoft-api' => 'zh'
	),
	'zh_SG' => array (
		'country' => "Singapore",
		'country-www' => 'sg',
		'lang' => 'Chinese',
		'lang-native' => '中文(新加坡)',
		'lang-www' => 'zh-SG',
		'dir' => 'ltr',
		'ms-loc' => 'zhi',
		'ms-cp' => 'CP936',
		'google-api' => 'zh',
		'microsoft-api' => 'zh'
	),
	'zh_TW' => array (
		'country' => "Taiwan",
		'country-www' => 'tw',
		'lang' => 'Chinese',
		'lang-native' => '中文(台灣)',
		'lang-www' => 'zh-TW',
		'dir' => 'ltr',
		'ms-loc' => 'cht',
		'ms-cp' => 'CP950',
		'google-api' => 'zh-TW',
		'microsoft-api' => 'zh-CHT'
	),
	'zu_ZU' => array (
		'country' => "South Africa",
		'country-www' => 'zu',
		'lang' => 'Zulu',
		'lang-native' => 'isiZulu',
		'lang-www' => 'zu-ZU',
		'dir' => 'ltr',
		'ms-loc' => 'zul',
		'ms-cp' => 'CP1252',
		'google-api' => '',
		'microsoft-api' => ''
	),
);
?>